/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.overlay.overlays.v2_1;

import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.drawables.device.v2_1.DeviceColor;
import com.roguewave.chart.drawables.device.v2_1.DeviceText;
import com.roguewave.chart.overlay.core.v2_1.ChartOverlay;
import com.roguewave.chart.overlay.core.v2_1.NumericFormatter;
import com.roguewave.chart.overlay.core.v2_1.ParameterCalculator;
import com.roguewave.chart.overlay.core.v2_1.ScaleConstants;
import com.roguewave.chart.richtext.v2_1.HTMLStyleParser;
import com.roguewave.chart.richtext.v2_1.TextBlock;
import com.roguewave.chart.richtext.v2_1.TextBlockDrawable;
import java.awt.Color;
import java.awt.Font;

public abstract class ScaleOverlayBase
implements ChartOverlay,
ScaleConstants {
    boolean scale_;
    NumericFormatter formatter_;
    Color labelColor_;
    Font labelFont_;
    int lowLabelOffset_ = 0;
    int highLabelOffset_ = 0;
    int scaleOffset_ = 2;

    public ScaleOverlayBase(boolean scale, NumericFormatter formatter, Color color, Font font) {
        this.scale_ = scale;
        this.formatter_ = formatter;
        this.labelColor_ = color;
        this.labelFont_ = font;
    }

    public int getItemWidth() {
        return 0;
    }

    public void addTo(ChartGraphics chartGraphics, DataModel data, int base, int left, int right, int offset, int columnWidth, ParameterCalculator params1, ParameterCalculator params2) {
        ParameterCalculator params;
        int placement;
        int x;
        if (this.scale_) {
            x = left - this.scaleOffset_;
            placement = 1;
            params = params1;
        } else {
            x = right + this.scaleOffset_;
            placement = 2;
            params = params2;
        }
        int lowIncrement = params.getLowIncrement();
        int highIncrement = params.getHighIncrement();
        int pixelsPerIncrement = params.getPixelsPerIncrement();
        double valueIncrement = params.getScaleIncrement();
        int count = highIncrement - lowIncrement + 1 - this.highLabelOffset_;
        chartGraphics.add2DDrawable(new DeviceColor(this.labelColor_));
        for (int i = this.lowLabelOffset_; i < count; ++i) {
            Drawable label;
            double value = this.calcValue(params, i);
            String text = this.formatter_.format(value);
            int y = base - i * pixelsPerIncrement - 2;
            if (text.indexOf(60) != -1) {
                TextBlock block = HTMLStyleParser.parse(text, null);
                label = new TextBlockDrawable(block, x, y, placement);
            } else {
                label = new DeviceText(text, x, y, placement, this.labelColor_, this.labelFont_);
            }
            chartGraphics.add2DDrawable(label);
        }
    }

    public Font getFont() {
        return this.labelFont_;
    }

    public void setFont(Font font) {
        this.labelFont_ = font;
    }

    public int getLowLabelOffset() {
        return this.lowLabelOffset_;
    }

    public void setLowLabelOffset(int offset) {
        this.lowLabelOffset_ = offset;
    }

    public int getHighLabelOffset() {
        return this.highLabelOffset_;
    }

    public void setHighLabelOffset(int offset) {
        this.highLabelOffset_ = offset;
    }

    public boolean getScale() {
        return this.scale_;
    }

    public void setScale(boolean scale) {
        this.scale_ = scale;
    }

    public int getScaleOffset() {
        return this.scaleOffset_;
    }

    public void setScaleOffset(int offset) {
        this.scaleOffset_ = offset;
    }

    public Color getLabelColor() {
        return this.labelColor_;
    }

    public void setLabelColor(Color color) {
        this.labelColor_ = color;
    }

    protected abstract double calcValue(ParameterCalculator var1, int var2);
}

